



<html>
<head>
  <title>javabog.dk -  - Objekter</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel4.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">3 <a name='afsn3'></a>Objekter</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Objekter
  og klasser</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Oprettelse af
  objekter og konstrukt&oslash;rer</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Brug af
  objekters variabler og metoder</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Punkter,
  rektangler, strenge, lister</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes
i resten af bogen.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;tter
<a href='kapitel2.jsp'>kapitel 2</a> Basal programmering.</P>


<H2 CLASS="western" STYLE="">3.1 <a name='afsn3.1'></a>Objekter og
klasser</SPAN></H2>
<P LANG="da-DK" CLASS="western">Hidtil har vi kun brugt de <I>simple
typer</I> (som<SPAN STYLE="font-weight: medium"> int, boolean og
double</SPAN>). Et javaprogram vil ofte udf&oslash;re mere komplekse
opgaver og dermed have brug for <I>objekter</I>. Et objekt
repr&aelig;senterer en eller anden (ofte fysisk) ting og
indeholder sammensatte data om denne ting, f.eks. et hus-objekt (med
adresse, telefonnummer, antallet af d&oslash;re og vinduer ...), en
bil, en person, en bankkonto, en selvangivelse, en ordre, et dokument
...</P>
<P LANG="da-DK" CLASS="western">Objekter kan klassificeres i
forskellige kategorier, kaldet <I>klasser</I>. F.eks. kunne man sige,
at alle hus-objekter tilh&oslash;rer Hus-klassen. Hus-klassen er en
beskrivelse af alle slags huse.</P>
<P LANG="da-DK" CLASS="western">N&aelig;sten alt er repr&aelig;senteret
som objekter i Java og der findes tusindvis af foruddefinerede
klasser til ting, som man ofte har brug for som programm&oslash;r
s&aring;som: tekststrenge, datoer, lister, filer og mapper,
vinduer, knapper, menuer, netv&aelig;rksforbindelser,
hjemmeside-adresser, billeder, lyde ...</P>
<P LANG="da-DK" CLASS="western">Et objekt indeholder data, der
beskriver det, som objektet repr&aelig;senterer. Et Fil-objekt har
oplysninger om den fil, det repr&aelig;senterer: Navn, placering,
type, dato for oprettelse og indhold. Et Person-objekt har m&aring;ske
variabler for fornavn, efternavn, CPR-nummer.</P>
<P LANG="da-DK" CLASS="western">Et objekt kan ogs&aring; indeholde
navngivne programstumper, som kan udf&oslash;res ved at give objektet
besked om det. Disse programstumper kaldes <I>metoder</I> og kan
opfattes som sp&oslash;rgsm&aring;l eller kommandoer, som man bruger
til at unders&oslash;ge og manipulere indholdet af objektet med. 
</P>
<P LANG="da-DK" CLASS="western">Et Fil-objekt har m&aring;ske metoden
&quot;omd&oslash;b()&quot;, der &aelig;ndrer filens navn, et
Person-objekt kan m&aring;ske give personens alder med metoden
&quot;hvadErDinAlder()&quot;.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Et objekt kan
indeholde metoder og data (variabler)</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En metode kan
&aelig;ndre p&aring; objektets data, n&aring;r den udf&oslash;res</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Ligesom med de simple typer afh&aelig;nger
det af objektets type, dets klasse, hvad man kan g&oslash;re med det.
Ordet &quot;klasse&quot; skal forst&aring;s i betydningen &quot;kategori,
gruppe&quot;. Alle objekter kan klassificeres som v&aelig;rende af en
bestemt type (klasse), f.eks. Streng, Dato, Fil, Knap.</P>
<P LANG="da-DK" CLASS="western">Objekter af samme klasse forst&aring;r
de samme beskeder (kommandoer og sp&oslash;rgsm&aring;l) og
indeholder samme slags data. Objekter af klassen Person
indeholder f.eks. begge et navn, men navnene (data) i de to
person-objekter, kan v&aelig;re forskellige.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog4_html_m138c9ddb.gif" NAME="Objekt12" ALIGN=BOTTOM></P>

<BLOCKQUOTE LANG="da-DK" CLASS="definition-western" STYLE="">
Et objekts type kaldes dets klasse</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Klassen
bestemmer, hvilke metoder og data et objekt har</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Vi tegner klasser, som vist her til
h&oslash;jre.  
</P>
<P LANG="da-DK" CLASS="western">&Oslash;verst er klassens navn,
dern&aelig;st data og n<IMG SRC="bog4_html_m2640a9fc.gif" NAME="Objekt49" ALIGN=RIGHT HSPACE=4>ederst
metoderne. 
</P>
<P LANG="da-DK" CLASS="western">Dette er en del af UML-notationen
(Unified Modelling Language), en notation, der ofte bliver anvendt i
forbindelse med objektorienteret programmering. 
</P>
<P LANG="da-DK" CLASS="western">I dette kapitel vil vi bruge objekter
fra foruddefinerede klasser. Vi har valgt at kigge n&aelig;rmere
p&aring; nogle klasser, der er velegnede til at illustrere ideerne,
nemlig Point, Rectangle, String, Date og ArrayList. 
</P>
<P LANG="da-DK" CLASS="western">String og ArrayList er nok de mest
brugte klasser overhovedet og er n&aelig;sten uundv&aelig;rlige
i praktisk programmering.</P>
<H2 CLASS="western">3.2 <a name='afsn3.2'></a>Punkter (klassen Point)</SPAN></H2>
<P LANG="da-DK" CLASS="western">Det f&oslash;rste objekt, vi vil
arbejde med, er Javas Point-objekt, der repr&aelig;senterer et <I>punkt</I>.
I Java indeholder et punkt to heltalsvariable, nemlig en x- og en
y-koordinat. Vi vil senere bruge Point-klassen, n&aring;r vi kommer
til programmering af grafik.</P>
<H3 CLASS="western">3.2.1 <a name='afsn3.2.1'></a>Erkl&aelig;ring og oprettelse</H3>
<P LANG="da-DK" CLASS="western">For at kunne arbejde med et objekt,
har man brug for en variabel, der refererer til objektet. En variabel
af typen Point (der refererer til et punkt) erkl&aelig;res ved at
skrive 
</P>
<PRE CLASS="kode-western"><CODE CLASS="western">  Point p;</CODE></PRE><P LANG="da-DK" CLASS="western">
Ligesom med de simple typer skriver man typen (Point) efterfulgt af
variabelnavnet. 
</P>
<P LANG="da-DK" CLASS="western">Nu har vi defineret, at <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
er en variabel til objekter af typen Point og vi kan lave et nyt
Point-objekt, som vi s&aelig;tter <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
til at pege p&aring;<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>:</P>
<PRE CLASS="kode-western"><CODE CLASS="western">  p = new Point();</CODE></PRE><P LANG="da-DK" CLASS="western">
Vi skriver alts&aring; new og klassens navn (Point) efterfulgt af
parenteser med startv&aelig;rdier for objektet. Her giver vi ingen
startv&aelig;rdier og parentesen er derfor tom.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Et objekt
oprettes med new</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">N&aring;r et
objekt oprettes, s&oslash;rger det for at s&aelig;tte dets data til
nogle fornuftige startv&aelig;rdier</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme5" DIR="LTR" STYLE="float: right; width: 4cm; height: 2.17cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_m35796a96.gif" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
  refererer til et punktobjekt.<BR>Objektet har x=0 og y=0</I></FONT></P>
</SPAN>I dette tilf&aelig;lde vil punktet starte med at have
koordinaterne (0,0) og situationen er, som vist p&aring; figuren til
h&oslash;jre: <FONT FACE="Courier, monospace"><FONT SIZE=2>p</FONT></FONT>
peger hen p&aring; et objekt, der har en x- og y-variabel, som begge
er sat til 0.
</P>
<P LANG="da-DK" CLASS="western">Man kan sige, at hver gang vi
anvender new-operatoren, bruger vi klassen som en slags st&oslash;beform,
til at skabe et nyt objekt med.</P>
<H3 CLASS="western" STYLE="">3.2.2 <a name='afsn3.2.2'></a>Objektvariabler</H3>
<P LANG="da-DK" CLASS="western">Vi kan unders&oslash;ge objektet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>'s
variabler. Her erkl&aelig;rer vi en anden variabel, <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">a</SPAN></SPAN></FONT></FONT>,
...</P>
<PRE CLASS="kode-western"><CODE CLASS="western">    int a;</CODE></PRE><P LANG="da-DK" CLASS="western">
... og gemmer <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>'s
x-koordinat i variablen:</P>
<PRE CLASS="kode-western"><CODE CLASS="western">    a = p.x;</CODE></PRE><P LANG="da-DK" CLASS="western">
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>'s
x-koordinat f&aring;r man fat i, ved at skrive <I>p punktum x</I>. Vi
kan derefter udskrive <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">a</SPAN></SPAN></FONT></FONT>:</P>
<PRE CLASS="kode-western">    System.out.println(&quot;a: &quot;+a);</PRE><P LANG="da-DK" CLASS="western">
Man kan ogs&aring; udskrive koordinaterne direkte, uden at bruge <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">a</SPAN></SPAN></FONT></FONT>
som mellemvariabel:</P>
<PRE CLASS="kode-western">    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);</PRE><P LANG="da-DK" CLASS="western">
Vi kan ogs&aring; &aelig;ndre <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>'s
koordinater:</P>
<DIV ID="Ramme22" DIR="LTR" STYLE="float: right; width: 4cm; height: 2.17cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_5dfdc114.gif" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Efter
  tildeling af p.x og p.y</I></FONT></P>
</DIV>
<PRE CLASS="kode-western">    p.x = 110;
    p.y = 210;</PRE><P LANG="da-DK" CLASS="western">
Variablerne x og y i Point-objektet kan behandles fuldst&aelig;ndig
som andre variabler af typen int, n&aring;r vi bare husker at skrive
&quot;p.&quot; foran. F.eks. kan man t&aelig;lle x-koordinaten op med
5:</P>
<PRE CLASS="kode-western">      p.x = p.x + 5;</PRE><P LANG="da-DK" CLASS="western">
x og y kaldes objektvariabler, fordi de tilh&oslash;rer objektet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>.
</P>
<H3 CLASS="western">3.2.3 <a name='afsn3.2.3'></a>Metodekald</H3>
<P LANG="da-DK" CLASS="western">I stedet for at &aelig;ndre objektet
udefra kan vi bede objektet selv udf&oslash;re &aelig;ndringen.
Metoden move() flytter punktet til et bestemt koordinats&aelig;t,
dvs. den <SPAN ID="Ramme24" DIR="LTR" STYLE="float: right; width: 4cm; height: 2.17cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_m678993b9.gif" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Efter
  kald af move(200,300)</I></FONT></P>
</SPAN>&aelig;ndrer x- og y-koordinaten.
</P>
<PRE CLASS="kode-western">    p.move(200,300);</PRE><P LANG="da-DK" CLASS="western">
Man siger, at man foretager et metodekald p&aring; objektet, som <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
refererer til og man skriver: <I>p punktum metodenavn parenteser</I>.
</P>
<P LANG="da-DK" CLASS="western">Efter metodekaldet til move(), har x-
og y-koordinaterne &aelig;ndret sig i det objekt, som <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
peger p&aring;. 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Et objekt kan
indeholde metoder<IMG SRC="bog4_html_m255949d0.gif" NAME="Objekt50" ALIGN=LEFT></BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Et metodekald p&aring;
et objekt kan &aelig;ndre objektets data</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Til h&oslash;jre er Point-klassen
illustreret i UML-notationen.</P>
<P LANG="da-DK" CLASS="western">Herunder er nogle af de metoder, som
punktobjekter forst&aring;r (en oversigt over klassen kan findes i
appendiks, <a href='kapitel3.jsp#afsn3.9.1'>afsnit 3.9.1</a>). 
</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af Point-klassens
metoder</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>move</B>(int x, int
y)<BR>S&aelig;tter punktets koordinater</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>translate</B>(int
x, int y)<BR>Rykker punktets koordinater relativt i forhold til, hvor
det er</P>
<P LANG="da-DK" CLASS="western">F&oslash;rst st&aring;r navnet p&aring;
metoden med fed, f.eks.: <B>move</B>.</P>
<P LANG="da-DK" CLASS="western">Derefter st&aring;r parametrene
adskilt af komma, f.eks.: (int x, int y).</P>
<P LANG="da-DK" CLASS="western">For hver parameter er angivet en type
og et navn. Typen angiver, hvilke v&aelig;rdier man kan kalde metoden
med og bruges til at kontrollere, at man har kaldt den med en v&aelig;rdi
af den rigtige type. Navnet i beskrivelsen bruges kun til at minde
om, hvad parameteren betyder.</P>


<P LANG="da-DK" CLASS="western">Bem&aelig;rk, at kaldet derfor ser
anderledes ud end beskrivelsen:</P>
<PRE CLASS="kode-western">  p.move(200,300);          <I>// korrekt</I>
  p.move(int 200, int 300); <I>// sprogfejl: parametertyper angivet ved kald.</I>
  p.move(x=200, y=300);     <I>// sprogfejl: parameternavne angivet ved kald.</I></PRE><BLOCKQUOTE LANG="da-DK" CLASS="definition-western">
I parenteserne i metodekaldet giver man oplysninger til objektet om,
hvordan man vil have metoden udf&oslash;rt</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Oplysningerne
kaldes parametre (eller argumenter)</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">I kaldet til move() ovenfor gav vi
oplysningerne 200 og 300 som parametre.</P>
<H3 CLASS="western">3.2.4 <a name='afsn3.2.4'></a>Eksempel</H3>
<P LANG="da-DK" CLASS="western">Her er et eksempel p&aring; tingene,
vi har vist ovenfor:</P>
<PRE CLASS="kode-western">import java.awt.*; <I>// Point-klassen skal importeres fra pakken java.awt</I>

public class BenytPunkter
{
  public static void main(String[] arg) 
  {
    Point p;
    p = new Point();

    int a;

    a = p.x;

    System.out.println(&quot;a: &quot;+a);

    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);

    p.x = 110;
    p.y = 210;
    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);

    p.move(200,300);
    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);

    p.x = p.x + 5;
    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);

    p.translate(-10,20);
    System.out.println(&quot;x-koordinat: &quot;+p.x);
    System.out.println(&quot;y-koordinat: &quot;+p.y);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">a: 0
x-koordinat: 0
y-koordinat: 0
x-koordinat: 110
y-koordinat: 210
x-koordinat: 200
y-koordinat: 300
x-koordinat: 205
y-koordinat: 300
x-koordinat: 195
y-koordinat: 320</PRE><H3 CLASS="western" STYLE="">
3.2.5 <a name='afsn3.2.5'></a>Import af standardklasser</H3>
<P LANG="da-DK" CLASS="western">&Oslash;verst i kildeteksten
&quot;importerer&quot; vi alle klasser i pakken java.awt:</P>
<PRE CLASS="kode-western">import java.awt.*;</PRE><P LANG="da-DK" CLASS="western">
Dette fort&aelig;ller overs&aelig;tteren, hvor den skal lede efter
definitionen af klasserne, vi bruger i programmet. I dette tilf&aelig;lde
er det for at overs&aelig;tteren skal kende til Point-klassen (der
findes i pakken java.awt).</P>
<P LANG="da-DK" CLASS="western">En pakke er en samling klasser med
besl&aelig;gtede funktioner. AWT st&aring;r for &quot;Abstract
Window Toolkit&quot; og java.awt indeholder forskellige nyttige
klasser til at tegne grafik p&aring; sk&aelig;rmen, herunder
klasser til at repr&aelig;sentere punkter og rektangler.</P>
<P LANG="da-DK" CLASS="western">Lige nu er det nok at vide, at de
fleste klasser skal importeres, f&oslash;r de kan bruges (hvis du er
meget nysgerrig, kan du l&aelig;se den f&oslash;rste del af <a href='kapitel6.jsp'>kapitel 6</a>
om pakker allerede nu).</P>
<H2 CLASS="western">3.3 <a name='afsn3.3'></a>Rektangler (klassen Rectangle)</SPAN></H2>
<P LANG="da-DK" CLASS="western">Vi vil nu g&aring; videre til nogle
lidt mere indviklede objekter af klassen Rectangle. Den bruges
sj&aelig;ldent i praksis (s&aring; du beh&oslash;ver ikke l&aelig;re
dens metoder udenad), men den er velegnet til at illustrere
ideer omkring oprettelse af objekter (konstrukt&oslash;rer) og
metodekald med returv&aelig;rdi.</P>
<P LANG="da-DK" CLASS="western">Et rektangel-objekt best&aring;r af
en x- og y-koordinat og en h&oslash;jde og bredde. Disse
objektvariabler (data) hedder <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">y</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">width</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">height</SPAN></SPAN></FONT></FONT>.</P>
<P LANG="da-DK" CLASS="western">En variabel med navnet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>
af typen Rectangle erkl&aelig;res med:</P>
<PRE CLASS="kode-western">    Rectangle r;</PRE><P LANG="da-DK" CLASS="western">
Ligesom med Point skal vi have lavet et rektangel-objekt, som <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>
refererer til, ellers peger <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>
ingen steder hen (den har v&aelig;rdien null):</P>
<PRE CLASS="kode-western">    r = new Rectangle();</PRE><P LANG="da-DK" CLASS="western">
Som med de simple typer kan man godt erkl&aelig;re variablen og
initialisere den i samme linje:</P>
<PRE CLASS="kode-western">    Rectangle r = new Rectangle();</PRE><P LANG="da-DK" CLASS="western">
<SPAN ID="Ramme1" DIR="LTR" STYLE="float: right; width: 3cm; height: 3.19cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_3d2998b5.gif" ALIGN=LEFT><BR CLEAR=LEFT><BR><BR>
  </P>
</SPAN>Det Rectangle-objekt, der oprettes, f&aring;r x,y,width og
height sat til 0.
</P>
<P LANG="da-DK" CLASS="western">Vi kan &aelig;ndre dette til
(1,1,10,10) med:</P>
<PRE CLASS="kode-western">    r.x = 1;
    r.y = 1;
    r.width = 10;
    r.height = 10;</PRE><P LANG="da-DK" CLASS="western">
Det er besv&aelig;rligt, hvis man skal bruge fire linjers programkode
p&aring;, at s&aelig;tte et objekts v&aelig;rdier, n&aring;r man
opretter det. Det kan g&oslash;res kortere.</P>
<H3 CLASS="western">3.3.1 <a name='afsn3.3.1'></a>Konstrukt&oslash;rer</H3>
<P LANG="da-DK" CLASS="western">N&aring;r man vil oprette et objekt
med bestemte startv&aelig;rdier, kan det g&oslash;res ved, at benytte
en <I>konstrukt&oslash;r</I>, hvor startv&aelig;rdierne kan angives.</P>
<P LANG="da-DK" CLASS="western">For eksempel kan et rektangel
oprettes med:</P>
<PRE CLASS="kode-western">    r = new Rectangle(1,1,10,10);</PRE><P LANG="da-DK" CLASS="western">
De fire parametre i parenteser fort&aelig;ller, at det rektangel, som
skal skabes, som start skal have det &oslash;verste venstre hj&oslash;rne
i (1,1) og en bredde og en h&oslash;jde p&aring; 10. 
</P>
<P LANG="da-DK" CLASS="western">Det er i virkeligheden en slags
metodekald, vi her foretager, s&aring; det er ikke nogen
tilf&aelig;ldighed, hvis det ligner.</P>

<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">N&aring;r man
skaber et nyt objekt med new, kaldes en konstrukt&oslash;r</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Konstrukt&oslash;ren
opretter objektet og initialiserer dets data (variabler)</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Nogle
konstrukt&oslash;rer har parametre, der beskriver, hvordan objektet
skal oprettes (hvilke v&aelig;rdier dets variabler skal have)</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Herunder er beskrevet tre
konstrukt&oslash;rer for Rectangle - dvs. tre m&aring;der, rektangler
kan oprettes p&aring;.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af Rectangle-klassens
konstrukt&oslash;rer</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Rectangle()<BR>opretter et rektangel i (0,0), hvis bredde og h&oslash;jde
er 0</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Rectangle(int bredde, int h&oslash;jde)<BR>opretter et rektangel i
(0,0) med den angivne bredde og h&oslash;jde</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Rectangle(int x, int y, int bredde, int h&oslash;jde)<BR>opretter et
rektangel i (x,y) med den angivne bredde og h&oslash;jde</P>

<P LANG="da-DK" CLASS="western">Point-klassens konstrukt&oslash;rer
er beskrevet i appendikset <a href='kapitel3.jsp#afsn3.9.1'>afsnit 3.9.1</a>. Vi kan f.eks. bruge den, der
har to parametre:</P>
<PRE CLASS="kode-western">    Point p;
    p= new Point(8,6);  <I>// skaber et Point med koordinaterne (8,6)</I></PRE><H3 CLASS="western">
3.3.2 <a name='afsn3.3.2'></a>Metoder</H3>
<P LANG="da-DK" CLASS="western">Vi vil nu lave et lille program, der
tjekker, om punktet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
ligger inde i rektanglet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>.
Vi erkl&aelig;rer en variabel, <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">inde</SPAN></SPAN></FONT></FONT>,
af type boolean, som vi kan bruge til at gemme resultatet af vores
unders&oslash;gelse i.</P>
<PRE CLASS="kode-western">    boolean inde;</PRE><P LANG="da-DK" CLASS="western">
Objekter af klassen Rectangle har en metode, contains(), som kan
fort&aelig;lle, om et punkt ligger inde i rektanglet:</P>
<PRE CLASS="kode-western">    inde = r.contains(p);</PRE><P LANG="da-DK" CLASS="western">
Det, der sker, er, at vi kalder metoden contains() - svarende til
sp&oslash;rgsm&aring;let <I>&quot;indeholder du </I><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><I>p</I></SPAN></SPAN></FONT></FONT><I>?&quot;</I>
- p&aring; rektanglet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>.
Vi giver <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
med som parameter, s&aring;ledes at rektanglets metode ved, at det
lige pr&aelig;cis er punktet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>,
som skal unders&oslash;ges. Metoden bliver udf&oslash;rt og foretager
nogle beregninger, som vi ikke kan se og til sidst kommer den ud med
et svar. Dette svar returneres til os og bliver gemt i variablen
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">inde</SPAN></SPAN></FONT></FONT>.
Modsat tilf&aelig;ldet med Point-objekters move()- og
translate()-metoder er rektanglers indhold u&aelig;ndret af kald af
contains().</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Ikke alle metoder
p&aring; et objekt &aelig;ndrer p&aring; det</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Nogle metoder
giver et svar tilbage (returnerer et resultat)</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Pr&oslash;v at sammenligne det med
kaldet til Math.sqrt(), som vi s&aring; i forrige kapitel:</P>
<PRE CLASS="kode-western">    hypotenuse = Math.sqrt(x*x + y*y);</PRE><P LANG="da-DK" CLASS="western">
Det er samme mekanisme: Vi sp&oslash;rger Math.sqrt() om, hvad
kvadratroden af x*x+y*y er og svaret, som metoden giver tilbage,
gemmer vi i variablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">hypotenuse</SPAN></SPAN></FONT></FONT>.</P>
<H3 CLASS="western" STYLE="">3.3.3 <a name='afsn3.3.3'></a>Metoders
returtype</H3>
<P LANG="da-DK" CLASS="western">Ligesom parametre skal v&aelig;re af
den rette type, g&aelig;lder for resultatet af et metode-kald at:</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En metode giver
et resultat af en bestemt type, n&aring;r den bliver udf&oslash;rt</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Dette kaldes
metodens returtype</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Math.sin() har returtypen double,
mens contains() p&aring; et rektangel-objekt har returtypen boolean.
Det er derfor, vores variabel <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">inde</SPAN></SPAN></FONT></FONT>
ogs&aring; skulle have typen boolean. 
</P>
<P LANG="da-DK" CLASS="western">Hvis punktet var inde i rektanglet,
s&aring; vil vi skrive det p&aring; sk&aelig;rmen:</P>
<PRE CLASS="kode-western">    if (inde==true)
    {
        System.out.println(”p er inde i r”);
    }</PRE><P LANG="da-DK" CLASS="western">
Herunder ses nogle af Rectangle-klassens metoder. Foran
metode-navnene st&aring;r returtyperne. I kursiv st&aring;r
sp&oslash;rgsm&aring;lene, som de svarer til. En mere komplet
oversigt over klassen kan findes  i appendiks i <a href='kapitel3.jsp#afsn3.9.2'>afsnit 3.9.2</a>.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af Rectangle-klassens
metoder.</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">boolean
</SPAN></SPAN><B>contains </B><SPAN STYLE="font-weight: medium">(Point
p)  </SPAN><I><SPAN STYLE="font-weight: medium">&quot;indeholder du
p?&quot;</SPAN></I><SPAN STYLE="font-weight: medium"><BR>returnerer
true, hvis </SPAN><I><SPAN STYLE="font-weight: medium">p</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">
er inden for rektanglet, ellers false.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-style: normal; font-weight: medium">
Point <B>getLocation</B>()  <I>&quot;hvad er din placering?&quot;</I></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-style: normal; font-weight: medium">
  returnerer et Point-objekt, der har samme koordinater som
rektanglets &oslash;verste venstre hj&oslash;rne.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">String
</SPAN></SPAN><SPAN STYLE="font-style: normal"><B>toString</B></SPAN><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">()  </SPAN></SPAN><I><SPAN STYLE="font-weight: medium">&quot;hvordan
vil du beskrive dig selv?&quot;</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium"><BR>giver
en beskrivelse af rektanglet med (x,y</SPAN></SPAN>)-koordinater og
m&aring;l som en streng.</P>
<P LANG="da-DK" CLASS="western">Her er Rectangle illustreret i
UML-notation. 
</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_m77b075b.gif" NAME="Objekt51" ALIGN=BOTTOM></P>
<P LANG="da-DK" CLASS="western">Returtyperne skrives her efter
metodenavnet. Ofte vil vi af hensyn til overskueligheden undlade
returtyperne (ligesom vi nogle gange undlader parametertyperne).</P>



<P LANG="da-DK" CLASS="western">Herunder ses et samlet eksempel med
to punkter. Det andet punkt, <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p2</SPAN></SPAN></FONT></FONT>,
unders&oslash;ger vi direkte i en if-s&aelig;tning uden at bruge en
mellemvariabel.</P>
<PRE CLASS="kode-western">import java.awt.*;

public class BenytRektangler
{
  public static void main(String[] arg)
  {
<CODE CLASS="western">    Point p, p2;</CODE>
<CODE CLASS="western">    Rectangle r;</CODE>

<CODE CLASS="western">    p = new Point();</CODE>
<CODE CLASS="western">    p2 = new Point(6,8);</CODE>
    r = <B>new Rectangle(1,1,10,10)</B>;

    boolean inde;
    inde = <B>r.contains(p)</B>;

    if (inde==true)
    {
        System.out.println(&quot;p er inde i r&quot;);
    }

    if (<B>r.contains(p2)</B>)
    {
        System.out.println(&quot;p2 er inde i r&quot;);
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">p2 er inde i r</PRE><H3 CLASS="western">
3.3.4 <a name='afsn3.3.4'></a>Metoders parametre</H3>
<P LANG="da-DK" CLASS="western">Her er et eksempel, der beregner
afstanden (distancen) mellem punktet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
og rektanglet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>'s
&oslash;verste venstre hj&oslash;rne. Det foreg&aring;r ved, at vi
sp&oslash;rger <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>:
getLocation() - &quot;<I>hvad er din position?</I>&quot;. Svaret
bruger vi som parameter til et sp&oslash;rgsm&aring;l til <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>:
distance(svaret fra <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>)
- &quot;<I><SPAN STYLE="font-weight: medium">Hvad er din afstand til
(svaret fra </SPAN></I><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><I>r</I></SPAN></SPAN></FONT></FONT><I><SPAN STYLE="font-weight: medium">)?</SPAN></I>&quot;</P>
<PRE CLASS="kode-western">    double afstand;
    afstand = p.distance(r.getLocation());</PRE><BLOCKQUOTE LANG="da-DK" CLASS="definition-western">
Ved et metodekald beregnes f&oslash;rst alle parametrene og derefter
udf&oslash;res metoden</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Dvs. f&oslash;rst beregnes
parameteren, getLocation() kaldes alts&aring; p&aring; <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>.
Den returnerer et punkt som er <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">r</SPAN></SPAN></FONT></FONT>'s
(x,y) og derefter kaldes distance() p&aring;<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">
p</SPAN></SPAN></FONT></FONT> med dette Point-objekt som parameter.</P>
<P LANG="da-DK" CLASS="western">Man kunne ogs&aring; bruge en
mellemvariabel og skrive:</P>
<PRE CLASS="kode-western">    Point rpunkt;
    rpunkt = r.getLocation();      <I>// rpunkt er r's &oslash;verste venstre hj&oslash;rne</I>
    afstand = p.distance(rpunkt);</PRE><P LANG="da-DK" CLASS="western">
Det er i starten lettere at l&aelig;se kode med mellemvariabler, men
n&aring;r eksemplerne bliver mere indviklede, bliver antallet af
mellemvariabler for stort. Man skal &oslash;ve sig i selv at
forestille sig, at der er nogle mellemregninger med mellemvariabler.</P>
<H2 CLASS="western" STYLE="">3.4 <a name='afsn3.4'></a>Tekststrenge
(klassen String)</SPAN></H2>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme8" DIR="LTR" STYLE="float: right; width: 2.57cm; height: 1.98cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_78cd1f1c.gif" NAME="Objekt14" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>s
  refererer <BR>ikke til noget</I></FONT></P>
</SPAN>Vi kommer nu til de mest brugte objekter, nemlig tekststrenge
(af typen String). En variabel, der refererer til strenge, erkl&aelig;res
ved at skrive
</P>
<PRE CLASS="kode-western">String s;</PRE><P LANG="da-DK" CLASS="western">
Nu har vi defineret, at <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s</SPAN></SPAN></FONT></FONT>
er en variabel, der kan referere til objekter af typen String, men
den peger endnu ikke p&aring; nogen konkret streng.<SPAN ID="Ramme29" DIR="LTR" STYLE="float: right; width: 2.57cm; height: 1.98cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_108ccb3a.gif" NAME="Objekt13" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>s
  refererer nu <BR>til en streng</I></FONT></P>
</SPAN>
</P>
<P LANG="da-DK" CLASS="western">Lad os tildele <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s</SPAN></SPAN></FONT></FONT>
en v&aelig;rdi. S&aring; er situationen som vist p&aring; figuren til
h&oslash;jre: 
</P>
<PRE CLASS="kode-western">s = &quot;Ude godt&quot;;</PRE><P LANG="da-DK" CLASS="western">
 Vi kan bruge <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s</SPAN></SPAN></FONT></FONT>
i vores program, f.eks. til at skrive ud p&aring; sk&aelig;rmen:</P>
<PRE CLASS="kode-western">System.out.println(&quot;Strengen s indeholder: &quot;+s);</PRE><P LANG="da-DK" CLASS="western">
Vi kan sp&oslash;rge streng-objektet om forskellige ting. For
eksempel kan vi kalde length(), der svarer til sp&oslash;rgsm&aring;let
&quot;hvor lang er du?&quot;:</P>
<PRE CLASS="kode-western">int strengensL&aelig;ngde;
strengensL&aelig;ngde = s.length();<I>  //  strengen svarer med tallet 8</I>
System.out.println(&quot;s er &quot;+strengensL&aelig;ngde+&quot; tegn lang&quot;);</PRE>
<HR>
<PRE CLASS="kode-western">s er 8 tegn lang </PRE><P LANG="da-DK" CLASS="western">
Vi kunne ogs&aring; springe mellemvariablen over og skrive: 
</P>
<PRE CLASS="kode-western">System.out.println(&quot;s er &quot;+s.length()+&quot; tegn lang&quot;); </PRE>
<P LANG="da-DK" CLASS="western">Metoden toUpperCase() svarer til
sp&oslash;rgsm&aring;let &quot;hvordan ser du ud med store
bogstaver?&quot;:</P>
<PRE CLASS="kode-western">System.out.println(&quot;s med store bogstaver: &quot;+s.toUpperCase());</PRE>
<HR>
<PRE CLASS="kode-western">s med store bogstaver: UDE GODT</PRE>
<P LANG="da-DK" CLASS="western">Herunder ses nogle af metoderne, man
kan kalde p&aring; strenge. I kursiv til h&oslash;jre st&aring;r
sp&oslash;rgsm&aring;lene, som de svarer til.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af String-klassens
metoder. En mere fuldst&aelig;ndig oversigt kan findes i <a href='kapitel3.jsp#afsn3.9.3'>afsnit 3.9.3</a>.</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>replace</B>
(String s&oslash;getekst, String erstatning)  <I>&quot;hvad hvis x
erstattes med y i strengen?&quot;</I><BR>giver en ny streng, som er
identisk med denne streng, bortset fra at alle steder i strengen hvor
teksten <I>s&oslash;getekst</I> st&aring;r er blevet erstattet med
teksten <I>erstatning</I><SPAN STYLE="font-style: normal">.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>substring</B>
(int startindeks)  <I>&quot;hvad er delstrengen fra x?&quot;</I><BR>giver
en ny streng, som er en del af denne streng. Delstrengen starter ved
<I>startindeks</I> og g&aring;r til slutningen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>substring</B>
(int startindeks, int slutindeks)  <I>&quot;hvad er delstrengen fra x
til y?&quot;</I><BR>giver en ny streng, som er en del af denne
streng. Delstrengen starter ved <I>startindeks</I> og slutter
ved <I>slutindeks</I> (til og med <I>slutindeks</I>-1).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toLowerCase</B>
()  <I>&quot;hvordan ser du ud med sm&aring; bogstaver?&quot;</I><BR>giver
en ny streng, som er identisk med denne streng, bortset fra at alle
store bogstaver er erstattet med sm&aring;.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toUpperCase</B>
()  <I>&quot;hvordan ser du ud med store bogstaver?&quot;</I><BR>giver
en ny streng, som er identisk med denne streng, bortset fra at alle
sm&aring; bogstaver er erstattet med store.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>equals</B>
(String str)  <I>&quot;er det samme indhold?&quot;</I><BR>giver sand,
hvis denne streng indeholder den samme tegnsekvens som <I>str</I>,
ellers falsk.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>length</B>
()    <I>&quot;hvad er din l&aelig;ngde?&quot;</I><BR>giver l&aelig;ngden
af (antal tegn i) strengen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>indexOf</B>
(String str)  <I>&quot;hvor er delstrengen x?&quot;</I><BR>giver
indeks p&aring; f&oslash;rste forekomst af <I>str</I> som delstreng.
Er <I>str</I> ikke er en delstreng, returneres -1.</P>

<P LANG="da-DK" CLASS="western">Herunder ses et eksempel, hvor nogle
af metoderne er afpr&oslash;vede:</P>
<PRE CLASS="kode-western"><I>// BenytStrenge.java</I>
<I>// Viser brugen af String-klassen og dens metoder.</I>
public class BenytStrenge
{
  public static void main(String[] arg)
  {
    String s;
    s = &quot;Ude godt&quot;;
    System.out.println(&quot;Strengen s indeholder: &quot;+s);
    System.out.println(&quot;s er &quot;+<B>s.length()</B>+&quot; tegn lang&quot;);
    System.out.println(&quot;s med store bogstaver: &quot;+<B>s.toUpperCase()</B>);
    System.out.println(&quot;Tekst p&aring; plads nummer 4 og frem: &quot;+<B>s.substring(4)</B>);
    System.out.println(&quot;Det f&oslash;rste g er p&aring; plads nummer: &quot;+<B>s.indexOf(&quot;g&quot;)</B>);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Strengen s indeholder: Ude godt
s er 8 tegn lang<BR>s med store bogstaver: UDE GODT
Tekst p&aring; plads nummer 4 og frem: godt
Det f&oslash;rste g er p&aring; plads nummer: 4</PRE><H3 CLASS="western">
3.4.1 <a name='afsn3.4.1'></a>Streng-objekter er uforanderlige</H3>
<P LANG="da-DK" CLASS="western">De fleste objekter tillader, at deres
data &aelig;ndres, enten ved at man direkte har adgang til deres
variabler eller gennem kald af metoder. 
</P>
<P LANG="da-DK" CLASS="western">N&aring;r vi skal &aelig;ndre i et
Point-objekt, f.eks. s&aring; dets x og y er (1,1), skriver vi:</P>
<PRE CLASS="kode-western">  p.move(1,1);                <I>// p forandres</I></PRE><P LANG="da-DK" CLASS="western">
S&aring;dan er det ikke med strenge: Metoderne i strenge er indrettet
s&aring;dan, at de ikke &aelig;ndrer i objektet. I stedet returneres
et nyt streng-objekt, som indeholder resultatet af &aelig;ndringen.</P>
<P LANG="da-DK" CLASS="western">Kalder man derfor en &aelig;ndringsmetode
p&aring; en streng, bliver strengen <I>ikke</I> &aelig;ndret:</P>
<PRE CLASS="kode-western">  s.replace(&quot;godt&quot;,&quot;fint&quot;);   <I>// objektet s peger p&aring; forandres ikke</I></PRE><P LANG="da-DK" CLASS="western">
replace() giver en ny streng tilbage til os, hvor alle steder med
&quot;godt&quot; er erstattet med &quot;fint&quot;, men den bliver
smidt v&aelig;k med det samme, da vi ikke bruger returv&aelig;rdien. 
</P>
<P LANG="da-DK" CLASS="western">I stedet skal vi huske returv&aelig;rdien:</P>
<PRE CLASS="kode-western">  String s2;
  s2 = s.replace(&quot;godt&quot;,&quot;fint&quot;);<I>// s forandres ikke, men s2 husker resultatet</I></PRE><P LANG="da-DK" CLASS="western">
Nu bliver resultat-strengen gemt vha. <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s2</SPAN></SPAN></FONT></FONT>
(den streng <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s</SPAN></SPAN></FONT></FONT>
peger p&aring; er som sagt uforandret). 
</P>
<P LANG="da-DK" CLASS="western">Her ses samlet et eksempel p&aring;,
hvordan man bruger streng:</P>
<PRE CLASS="kode-western"><I>// BenytStrenge2.java</I>
public class BenytStrenge2
{
  public static void main (String[] arg)
  {
    String s1, s2, s3, s4;
    s1 = &quot;Ude godt, men hjemme bedst.&quot;;
    s1.toUpperCase();          <I>// lav store bogstraver, men smid resultatet v&aelig;k</I>
    <B>s2 = s1.toUpperCase()</B>;     <I>// lav store bogstraver fra s1, gem det i s2</I>
    <B>s3 = s2.replace(&quot;E&quot;, &quot;X&quot;)</B>; <I>// erstat E med X p&aring; s2 og gem resultatet i s3</I>
    <B>s4 = s3.substring(4, 16)</B>;  <I>// tag delstreng p&aring; s3 og gem resultatet i s4</I>

    System.out.println (&quot;s1: &quot; + s1);  <I>// s1 er stadig med sm&aring; bogstaver</I>
    System.out.println (&quot;s2: &quot; + s2);  <I>// s2 har ikke f&aring;et &aelig;ndret E til X</I>
    System.out.println (&quot;s3: &quot; + s3);  <I>// s3 er ikke delstrengen p&aring; plads 4-16</I>
    System.out.println (&quot;s4: &quot; + s4);  <I>// s4 er delstrengen p&aring; plads 4-16</I>
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">s1: Ude godt, men hjemme bedst.
s2: UDE GODT, MEN HJEMME BEDST.
s3: UDX GODT, MXN HJXMMX BXDST.
s4: GODT, MXN HJ</PRE><P LANG="da-DK" CLASS="western" STYLE="">
Variablerne <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s2</SPAN></SPAN></FONT></FONT>,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s3</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s4</SPAN></SPAN></FONT></FONT>
f&aring;r tildelt en reference (pegepind) til hvert sit strengobjekt
og derefter &aelig;ndrer deres indhold sig ikke, uanset hvilke
metoder der kaldes p&aring; objekterne.</P>

<P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
Bem&aelig;rk, at selvom streng-objekterne i sig selv er
uforanderlige, kan streng-<I>variabler</I> godt &aelig;ndres:</P>
<PRE CLASS="kode-western">  s = s.replace('d','f');  <I>// s&aelig;t s til at referere resultatet af replace()</I></PRE>
<P LANG="da-DK" CLASS="western">Forskellen mellem en metode, der
&aelig;ndrer p&aring; det objekt, den bliver kaldt p&aring; og en
metode, der returnerer en v&aelig;rdi, kan v&aelig;re sv&aelig;r at
forst&aring; i starten, men det kommer i takt med, at du programmerer
selv.</P>
<H3 CLASS="western">3.4.2 <a name='afsn3.4.2'></a>Man beh&oslash;ver ikke bruge new til
String-objekter</H3>
<P LANG="da-DK" CLASS="western">De andre klasser, vi har set indtil
nu, har vi brugt til at skabe nye objekter med. N&aring;r vi skulle
lave et nyt Point-objekt, kaldte vi dens konstrukt&oslash;r vha. new,
f.eks.:</P>
<PRE CLASS="kode-western"><CODE CLASS="western">  Point p;</CODE>
<CODE CLASS="western">  p = new Point(0,0);</CODE></PRE><P LANG="da-DK" CLASS="western">
Lige netop med strenge beh&oslash;ves det ikke. Her skriver man
typisk:</P>
<PRE CLASS="kode-western"><CODE CLASS="western">  String s;</CODE>
<CODE CLASS="western">  s = &quot;Ude godt&quot;;</CODE></PRE><P LANG="da-DK" CLASS="western">
Man <I>kan</I><SPAN STYLE="font-style: normal"> godt skriv</SPAN>e:</P>
<PRE CLASS="kode-western">  s = new String(&quot;Ude godt&quot;);</PRE><P LANG="da-DK" CLASS="western">
I det sidste tilf&aelig;lde skabes et nyt String-objekt, som ogs&aring;
indeholder teksten &quot;Ude godt&quot;, s&aring; der i lageret er <I>to</I><SPAN STYLE="font-style: normal">
strenge med samme indhold, hvilket er un&oslash;dvendigt</SPAN>.
Netop fordi strenge ikke kan &aelig;ndres, n&aring;r de f&oslash;rst
er skabt, har man aldrig brug for kopier. Hvorfor skulle man lave en
kopi, n&aring;r den alligevel altid vil v&aelig;re helt den samme som
originalen?</P>
<H3 CLASS="western">3.4.3 <a name='afsn3.4.3'></a>Navnesammenfald for metoder</H3>
<P LANG="da-DK" CLASS="western">I tabellen over Strings metoder er
der en, der er n&aelig;vnt to gange; substring(). Den findes i to
varianter: <B>substring</B>(int startindeks) og <B>substring</B>(int
startindeks, int slutindeks). 
</P>
<P LANG="da-DK" CLASS="western">Hvilken variant der kaldes i
BenytStrenge2.java ved tildelingen af <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s4</SPAN></SPAN></FONT></FONT>,
kan man se ud fra hvilke parameterlister, der passer sammen. I
dette tilf&aelig;lde den metode med to parametre. 
</P>
<P LANG="da-DK" CLASS="western">S&aring; l&aelig;nge der er forskel
p&aring; antallet af parametre, er det simpelt nok, ellers m&aring;
man kigge p&aring; typerne af parametrene.</P>
<H3 CLASS="western">3.4.4 <a name='afsn3.4.4'></a>At s&aelig;tte strenge sammen med +</H3>
<P LANG="da-DK" CLASS="western">Operatoren + bruges ikke kun til at
l&aelig;gge tal sammen. Hvis enten h&oslash;jre- eller venstre-siden
er en streng, bliver + opfattet som: &quot;<I>konverter begge sider
til strenge og s&aelig;t dem i forl&aelig;ngelse af hinanden til
en samlet streng</I>&quot;. 
</P>
<P LANG="da-DK" CLASS="western">Hvis man f.eks. skriver:</P>
<PRE CLASS="kode-western">  Point p;
  p=new Point(1,1);
  System.out.println(<B>&quot;Svaret er: &quot;+p</B>);</PRE>
<HR>
<PRE CLASS="kode-western">Svaret er: java.awt.Point[x=1,y=1]</PRE><P LANG="da-DK" CLASS="western">
Sker der i computeren nogenlunde f&oslash;lgende:</P>
<PRE CLASS="kode-western" STYLE="; ">  String s1;
  String s2;
  String s3;
  <B>s1 = &quot;Svaret er: &quot;</B>;
  <B>s2 = p.toString()</B>;  <I>// toString() er en metode alle objekter har</I>
  <B>s3 = s1 + s2</B>;
  System.out.println(<B>s3</B>);</PRE>
<P LANG="da-DK" CLASS="western" STYLE="">Metoden
toString() laver en streng-repr&aelig;sentation af et objekt. Alle
objekter har en toString()-metode og overs&aelig;tteren s&aelig;tter
kode ind, der kalder toString(), hvis den m&oslash;der et + mellem en
streng og en anden slags objekt.</P>
<P LANG="da-DK" CLASS="western">Alle de simple typer kan ogs&aring;
laves om til strenge med +:</P>
<PRE CLASS="kode-western">  int i;
  i = 42;
  System.out.println(&quot;Svaret er: &quot;+i);</PRE><P LANG="da-DK" CLASS="western">
Java kigger ikke p&aring; indholdet af strengene, s&aring; &quot;2&quot;
(som streng) + 3 (som tal) giver &quot;23&quot; (som streng). 
</P>
<P LANG="da-DK" CLASS="western">Man kan alts&aring; bruge operatoren
+ til et lille trick: For at f&aring; noget repr&aelig;senteret
som en streng, kan man sammens&aelig;tte det med en tom streng:</P>
<PRE CLASS="kode-western">  String s;
  int i;
  i = 42;
  s = &quot;&quot;+i; <I>// nu refererer s til strengen &quot;42&quot;</I></PRE><P LANG="da-DK" CLASS="western">
Man kan derimod ikke skrive:</P>
<PRE CLASS="kode-western">  s = i;   <I>// sprogfejl: konverterer ikke automatisk fra int til String. </I></PRE><P LANG="da-DK" CLASS="western">
...eller...</P>
<PRE CLASS="kode-western">  i = s+1; <I>// sprogfejl: konverterer ikke automatisk fra String til int.</I></PRE><P LANG="da-DK" CLASS="western">
... selvom <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s</SPAN></SPAN></FONT></FONT>
er &quot;42&quot;. 
</P>
<H3 CLASS="western">3.4.5 <a name='afsn3.4.5'></a>Sammenligning</H3>
<P LANG="da-DK" CLASS="western">Umiddelbart kunne man fristes til at
sammenligne to strenge med == ligesom med de simple typer. Det g&aring;r
ofte (men ikke altid!) godt:</P>
<PRE CLASS="kode-western">    s1 = &quot;Hej verden&quot;;
    s2 = s1;
    <B>if (s1 == s2) </B>System.out.println(&quot;s1 og s2 er ens.&quot;);<I>       // </I><I><B>forkert</B></I><I>!</I>
    else System.out.println(&quot;s1 og s2 er IKKE ens.&quot;); </PRE>
<HR>
<PRE CLASS="kode-western">s1 og s2 er ens.</PRE><P LANG="da-DK" CLASS="western">
Imidlertid sammenligner == ikke <I>indholdet af</I><SPAN STYLE="font-style: normal">
objekterne, men </SPAN><I>referencerne til</I> (adresserne p&aring;),
<SPAN STYLE="font-style: normal">objekterne</SPAN>. Sammenligningen
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1==s2</SPAN></SPAN></FONT></FONT>
er kun sand, fordi <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s2</SPAN></SPAN></FONT></FONT>
peger p&aring; det samme objekt. 
</P>
<P LANG="da-DK" CLASS="western">Derfor vil <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1==s2</SPAN></SPAN></FONT></FONT>
altid v&aelig;re falsk, hvis <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s2</SPAN></SPAN></FONT></FONT>
refererer til to objekter forskellige steder i hukommelsen, ogs&aring;
selvom de har samme indhold:</P>
<PRE CLASS="kode-western">    s1 = &quot;Hej verden&quot;;
    s2 = &quot;Hej &quot; + s1.substring(4); <I>// giver &quot;Hej &quot;+&quot;verden&quot; = &quot;Hej verden&quot;</I>
    <B>if (s1 == s2) </B>System.out.println(&quot;s1 og s2 er ens.&quot;);<I>       // </I><I><B>forkert</B></I><I>!</I>
    else System.out.println(&quot;s1 og s2 er IKKE ens.&quot;); </PRE>
<HR>
<PRE CLASS="kode-western">s1 og s2 er IKKE ens.</PRE><P LANG="da-DK" CLASS="western">
I stedet b&oslash;r man kalde equals()-metoden, dvs. sp&oslash;rge et
af objekterne &quot;<I>har du samme indhold som dette objekt?</I>&quot;
og give det andet objekt som parameter:</P>
<PRE CLASS="kode-western">    <B>if (s1.equals(s2))</B> System.out.println(&quot;s1 og s2 er ens.&quot;);  <I><B>// korrekt</B></I>
    else System.out.println(&quot;s1 og s2 er IKKE ens.&quot;); </PRE>
<HR>
<PRE CLASS="kode-western">s1 og s2 er ens.</PRE><P LANG="da-DK" CLASS="western">
Dette g&aelig;lder i virkeligheden ikke kun strenge. Alle objekter
har en equals()-metode, som kan bruges til at afg&oslash;re, om
indholdet af to objekter er ens og den b&oslash;r bruges fremfor ==.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Sammenligning af
adresser p&aring; objekter sker med ==</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Sammenligning af
objekters indhold sker med equals()-metoden</BLOCKQUOTE>

<H3 CLASS="western" STYLE="">3.4.6 <a name='afsn3.4.6'></a>Opgaver</H3>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der finder
  positionen af det f&oslash;rste mellemrum i en streng.<BR>(vink:
  Brug metoden indexOf(&quot; &quot;))</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der fjerner
  det f&oslash;rste ord i en s&aelig;tning (indtil f&oslash;rste
  mellemrum).</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der t&aelig;ller
  antallet af mellemrum i en tekst.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der fjerner
  den f&oslash;rste forekomst af ordet &quot;m&aring;ske&quot; fra en
  tekst.<BR>&AElig;ndr derefter programmet, s&aring; det fjerner alle
  forekomster af ordet (brug en l&oslash;kke).</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der finder og
  fjerner alle forekomster af ordet &quot;m&aring;ske&quot; fra en
  tekst, uanset om det er skrevet med store eller sm&aring; bogstaver.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der
  unders&oslash;ger, om en tekst er et palindrom, dvs. med samme
  stavning forfra og bagfra (som f.eks. &quot;regninger&quot;,
  &quot;russerdressur&quot;, &quot;v&aelig;r dog god r&aelig;v&quot;).<BR>(vink:
  Tr&aelig;k de enkelte tegn ud af strengene med substring(n,n+1) og
  husk, at strengobjekter skal sammenlignes med
  .equals()-metoden: s1.equals(s2)).</P>
  <LI><P LANG="da-DK" CLASS="western">Udvid programmet til at tage
  h&oslash;jde for store/sm&aring; bogstaver, tegns&aelig;tning og
  mellemrum, s&aring;dan at de f&oslash;lgende palindromer ogs&aring;
  genkendes: &quot;Selmas lakser&oslash;de garaged&oslash;re skal
  samles&quot; og &quot;&Aring;ge lo, da baronesse Nora bad Ole g&aring;&quot;.</P>
</OL>
<H2 CLASS="western">3.5 <a name='afsn3.5'></a>Lister (klassen ArrayList)</SPAN></H2>
<P LANG="da-DK" CLASS="western">En ArrayList er en liste af objekter,
der bliver nummereret efter et indeks.</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_m14fe6c9a.gif" NAME="Objekt52" ALIGN=BOTTOM></P>
<P LANG="da-DK" CLASS="western">Konstrukt&oslash;rer og metoder er
beskrevet i appendiks, <a href='kapitel3.jsp#afsn3.9.6'>afsnit 3.9.6</a>.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En ArrayList er
en liste af objekter</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">En liste oprettes normalt med viden
om hvilken slags objekter, den skal indeholde. F.eks.:</P>
<PRE CLASS="kode-western">  ArrayList&lt;String&gt; liste;
  liste = new ArrayList&lt;String&gt;();</PRE><P LANG="da-DK" CLASS="western">
opretter en liste af strenge. Man tilf&oslash;jer elementer til
listen med liste.<B>add</B>( ), f.eks.:</P>
<PRE CLASS="kode-western">  liste.add(&quot;&aelig;h&quot;);</PRE><P LANG="da-DK" CLASS="western">
der tilf&oslash;jer strengen &quot;&aelig;h&quot; til listen.</P>
<P LANG="da-DK" CLASS="western">Man kan s&aelig;tte ind midt i listen
med liste.add( indeks , objekt ), f.eks.:</P>
<PRE CLASS="kode-western">  liste.add(0,&quot;&oslash;h&quot;);</PRE><P LANG="da-DK" CLASS="western">
der inds&aelig;tter &quot;&oslash;h&quot; p&aring; plads nummer 0,
s&aring;dan at listen nu indeholder f&oslash;rst &quot;&oslash;h&quot;
og s&aring; &quot;&aelig;h&quot;. Alle elementerne fra og med det
indeks, hvori man inds&aelig;tter, f&aring;r alts&aring; rykket deres
indeks et frem. 
</P>
<P LANG="da-DK" CLASS="western">Man afl&aelig;ser et element i listen
med liste.<B>get</B>( indeks ).</P>
<P LANG="da-DK" CLASS="western">Med liste.<B>size</B>() f&aring;r man
antallet af elementer i listen, i dette tilf&aelig;lde 2.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm; ">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af ArrayList-klassens
metoder</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>add </B>(
element )<BR>F&oslash;jer <I>element</I><SPAN STYLE="font-style: normal">
til listen. </SPAN><I>element</I><SPAN STYLE="font-style: normal">
skal v&aelig;re af ArrayList-objektets type.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>add </B>( int
indeks , element )<BR>Inds&aelig;tter <I>element</I><SPAN STYLE="font-style: normal">
i listen lige f&oslash;r plads nummer </SPAN><I>indeks</I>. F&oslash;rste
element er p&aring; plads nummer 0.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>remove </B>(
int indeks )<BR>Sletter elementet p&aring; <SPAN STYLE="font-style: normal">plads
nummer </SPAN><I>indeks.</I></P>

<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>size
</B>()<BR>returnerer antallet af elementer i listen.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western">Object <B>get </B>(
int indeks )<BR>Returnerer en reference til objektet p&aring; plads
nummer <I>indeks</I><SPAN STYLE="font-style: normal"> (regnet fra 0).
</SPAN>
</P>

<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toString</B>
()<BR>returnerer listens indhold som en streng. Dette sker ved, at
konvertere hver af elementerne til en streng.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>ArrayList-klassen skal
importeres med <FONT FACE="Courier, monospace">import java.util.*;</FONT>
f&oslash;r den kan bruges</I></FONT></P>
<P LANG="da-DK" CLASS="western"><SPAN ID="Frame1" DIR="LTR" STYLE="float: right; width: 2.98cm; height: 3.23cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog4_html_3b843ec8.gif" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>listen
  lige efter<BR>inds&aelig;ttelse af &quot;buh&quot;</I></FONT></P>
</SPAN>Her er et lille eksempel:
</P>
<PRE CLASS="kode-western">import java.util.*;

public class BenytArrayList
{
  public static void main(String[] arg)
  {
    ArrayList&lt;String&gt; liste;         <I>// opret liste-variabel</I>
    <B>liste = new ArrayList&lt;String&gt;()</B>; <I>// opret liste-objekt</I>

    <B>liste.add(&quot;&aelig;h&quot;);</B>                 <I>// f&oslash;j til listen</I>
<B>    liste.add(&quot;b&aelig;h&quot;);</B>
<B>    liste.add(&quot;buh&quot;);</B>

    System.out.println(&quot;Listen har elementerne &quot;<B>+liste.toString()</B>);

<B>    liste.add(2,&quot;og&quot;);</B>
    System.out.println(&quot;Nu har listen &quot;<B>+liste</B>); <I>// .toString() kaldes implicit</I>

<B>    liste.remove(0);</B>
    System.out.println(&quot;Nu har listen <SPAN STYLE="font-weight: medium">&quot;+liste+&quot; og st&oslash;rrelsen &quot;+</SPAN><B>liste.size()</B>);
    System.out.println(&quot;P&aring; plads nummer 1 er: <SPAN STYLE="font-weight: medium">&quot;+</SPAN><B>liste.get(1)</B>);

    <B>for (String element : liste)</B> {  <I>// genneml&oslash;b alle elementerne i listen</I>
      System.out.println(&quot;Et element i listen: &quot;+ <B>element</B>);
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Listen har elementerne [&aelig;h, b&aelig;h, buh]
Nu har listen [&aelig;h, b&aelig;h, og, buh]
Nu har listen [b&aelig;h, og, buh] og st&oslash;rrelsen 3
P&aring; plads nummer 1 er: og
Et element i listen: b&aelig;h
Et element i listen: og
Et element i listen: buh</PRE><P LANG="da-DK" CLASS="western">
Vi inds&aelig;tter f&oslash;rst tre (referencer til) strenge i listen
(se figur). Dern&aelig;st l&aelig;gges &quot;og&quot; ind p&aring;
plads nummer 2, dvs. efter &quot;b&aelig;h&quot; og f&oslash;r &quot;buh&quot;.
Til sidst fjernes &quot;&aelig;h&quot; p&aring; plads nummer 0.</P>
<P LANG="da-DK" CLASS="western">Lister kan blive vilk&aring;rligt
lange. De s&oslash;rger selv for at reservere mere hukommelse,
hvis det bliver n&oslash;dvendigt.</P>

<H3 CLASS="western">3.5.1 <a name='afsn3.5.1'></a>Genneml&oslash;b af lister</H3>
<P LANG="da-DK" CLASS="western">L&aelig;g m&aelig;rke til, hvordan
man kan genneml&oslash;be en liste:</P>
<PRE CLASS="kode-western">    <B>for (String element : liste)</B> {
      System.out.println(&quot;Et element i listen: &quot;+ <B>element</B>);
    }</PRE><P LANG="da-DK" CLASS="western">
Denne specielle syntaks til for-l&oslash;kken (foreach) er beregnet
til at genneml&oslash;be alle elementerne i en liste. Den har den
generelle form:</P>
<PRE CLASS="kode-western">    for (<I>Elementtype elementvariabel</I> : <I>liste</I>) <I>kommando;</I></PRE>

<H3 CLASS="western">3.5.2 <a name='afsn3.5.2'></a>Eksempel: Eventyrfort&aelig;lling</H3>
<P LANG="da-DK" CLASS="western">Her er et program, der kombinerer
forskellige personer og handlinger til et lille eventyr:</P>
<PRE CLASS="kode-western">import java.util.*;

public class Eventyr
{
  public static void main(String[] arg)
  {
    ArrayList&lt;String&gt; personer = new ArrayList&lt;String&gt;(); <I>// liste af strenge</I>
    personer.add(&quot;De tre sm&aring; grise&quot;);
    personer.add(&quot;Ulven&quot;);
    personer.add(&quot;R&oslash;dh&aelig;tte&quot;);

    ArrayList&lt;String&gt; handlinger = new ArrayList&lt;String&gt;();
    handlinger.add(&quot;slikker sig om munden&quot;);
    handlinger.add(&quot;f&aring;r en id&eacute;!&quot;);
    handlinger.add(&quot;gemmer sig i skoven&quot;);

    for (int i=0; i&lt;5; i++) {
      int personNummer = (int) (Math.random()*personer.size());
      String person = personer.get( personNummer );
      String handling = handlinger.get( (int)(Math.random()*handlinger.size()));
      System.out.println(person + &quot; &quot; + handling);
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Ulven f&aring;r en id&eacute;!
Ulven slikker sig om munden
R&oslash;dh&aelig;tte gemmer sig i skoven
De tre sm&aring; grise slikker sig om munden
Ulven gemmer sig i skoven</PRE>
<H4 CLASS="western">Opgave</H4>
<P LANG="da-DK" CLASS="western">Udvid programmet, s&aring; eventyret
bliver mere interessant.</P>

<H3 CLASS="western">3.5.3 <a name='afsn3.5.3'></a>Eksempel: Punkter i en liste</H3>
<P LANG="da-DK" CLASS="western">I det n&aelig;ste eksempel l&aelig;gges
tre Point-objekter ind i en liste og listen genneml&oslash;bes, for
at finde punktet med den mindste afstand til (0,0) (ogs&aring; kaldet
origo).</P>

<PRE CLASS="kode-western">import java.awt.*;
import java.util.*;

public class MindsteAfstand
{
  public static void main(String[] arg)
  {
    ArrayList&lt;Point&gt; punktliste;<I>    // punkt-liste</I>
    Point origo, p1, p2, p3;
    double minDist = 10000;
    punktliste = new ArrayList&lt;Point&gt;();
    origo = new Point(0,0);
    p1 = new Point(0,65);
    p2 = new Point(50,50);
    p3 = new Point(120,10);
    
    punktliste.add(p1);
    punktliste.add(p2);
    punktliste.add(p3);
    
    for (Point p : punktliste)
    {
      double dist;

      dist = origo.distance(p);
      if (dist&lt;minDist)
      {
        minDist=dist;
      }
    }

    System.out.println(&quot;Den mindste afstand mellem punkterne &quot;
      + punktliste + &quot; og (0,0) er &quot;+minDist);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Den mindste afstand mellem punkterne [java.awt.Point[x=0,y=65], java.awt.Point[x=50,y=50], java.awt.Point[x=120,y=10]] og (0,0) er 65.0</PRE>
<H3 CLASS="western">3.5.4 <a name='afsn3.5.4'></a>Historisk bem&aelig;rkning: Lister f&oslash;r
JDK 1.5</H3>
<P LANG="da-DK" CLASS="western">Bruger du en &aelig;ldre udgave af
Java (eller skal dit program ogs&aring; virke i &aelig;ldre udgaver
af Java), er du n&oslash;dt til at arbejde med lister, s&aring;dan
som man gjorde, f&oslash;r JDK 1.5 kom.</P>
<P LANG="da-DK" CLASS="western">F&oslash;r JDK 1.5 kom i 2004, m&aring;tte
man bruge en t&aelig;llevariabel, der l&oslash;b fra 0 til listens
st&oslash;rrelse (liste.size()) til at genneml&oslash;be listen
element for element. Programkoden s&aring; ofte ud som:</P>
<PRE CLASS="kode-western">    for (int n=0; n&lt;<B>liste.size()</B>; n++) {
      <B>String element = </B><SPAN STYLE="font-weight: medium">(String) </SPAN><B>liste.get(n);</B>
      System.out.println(&quot;Element nummer &quot;+n+&quot; i listen: &quot;+ <B>element</B>);
    }</PRE>
<HR>
<PRE CLASS="kode-western">Element nummer 0 i listen: b&aelig;h
Element nummer 1 i listen: og
Element nummer 2 i listen: buh</PRE><P LANG="da-DK" CLASS="western">
Hvis man har brug for at kende elementets nummer (her er det i
variablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>),
kan den gamle m&aring;de stadig v&aelig;re den bedste.</P>
<P LANG="da-DK" CLASS="western">F&oslash;r JDK 1.5 var man ogs&aring;
henvist til at oprette lister uden at angive elementernes type:</P>
<PRE CLASS="kode-western">    ArrayList liste;         <I>// opret liste-variabel uden &lt;String&gt;-elementtype</I>
    <B>liste = new ArrayList()</B>; <I>// opret liste-objekt uden &lt;String&gt;-elementtype</I></PRE><P LANG="da-DK" CLASS="western">
I stedet m&aring;tte man foretage en eksplicit typekonvertering, n&aring;r
man tog noget ud af listen:</P>
<PRE CLASS="kode-western">    for (int i=0; i&lt;liste.size(); i++) {
      String element = <B>(String)</B> liste.get(i);
      System.out.println(&quot;Element nummer &quot;+n+&quot; i listen: &quot;+ <B>element</B>);
    }</PRE>

<H3 CLASS="western">3.5.5 <a name='afsn3.5.5'></a>Eksempel: Blanding af kort med ArrayList</H3>
<P LANG="da-DK" CLASS="western">I det f&oslash;lgende bruges nogle af
de metoder, der er n&aelig;vnt i appendikset om ArrayList (<a href='kapitel3.jsp#afsn3.9.6'>afsnit 3.9.6</a>).
Dette program blander nogle spillekort (beskrevet som strenge<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>)
i en liste:</P>
<PRE CLASS="kode-western">import java.util.*;
 
public class BlandKort
{
  public static void main(String[] arg)
  {
    ArrayList<B>&lt;String&gt; bunke = new ArrayList&lt;String&gt;();</B>

<I>    // Opbyg bunken</I>
    for (int n=2; n&lt;9; n++)
    {
      bunke.add(&quot;ruder&quot;+n);  <I>// ruder</I>
      bunke.add(&quot;kl&oslash;r&quot;+n);   <I>// kl&oslash;r</I>
      bunke.add(&quot;spar&quot;+n);   <I>// spar</I>
    }

    System.out.println(&quot;F&oslash;r blanding: &quot;+bunke);   <I>// bunke.toString() kaldes</I>
    int antalKort = bunke.size();

<I>    // Bland bunken</I>
    for (int n=0; n&lt;100; n++)
    {
      int nr = (int) (Math.random() * antalKort); <I>// find en tilf&aelig;ldig plads</I>

      String <B>kort = bunke.get(nr)</B>;                <I>// tag et kort ud</I>
      <B>bunke.remove(nr);</B>

      nr = (int) (Math.random() * antalKort);
<B>      bunke.add(nr, kort);</B>                        <I>// s&aelig;t det ind et andet sted</I>
    }
    
    System.out.println(&quot;Efter blanding: &quot;+bunke);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">F&oslash;r blanding: [ruder2, kl&oslash;r2, spar2, ruder3, kl&oslash;r3, spar3, ruder4, kl&oslash;r4, spar4,
ruder5, kl&oslash;r5, spar5, ruder6, kl&oslash;r6, spar6, ruder7, kl&oslash;r7, spar7, ruder8, kl&oslash;r8,
spar8]
Efter blanding: [spar3, kl&oslash;r3, ruder7, spar5, spar2, ruder5, ruder6, kl&oslash;r6, spar6, kl&oslash;r5, kl&oslash;r8, ruder2, ruder4, kl&oslash;r7, ruder3, spar8, spar4, ruder8, kl&oslash;r4, kl&oslash;r2, spar7]</PRE><P LANG="da-DK" CLASS="western">
Blandingen udf&oslash;res ved 100 gange at tage et kort fra en
tilf&aelig;ldig plads (med get()), fjerne det (med remove()) og
flytte det til en anden tilf&aelig;ldig plads (med add() p&aring; den
nye plads).</P>


<H2 CLASS="western">3.6 <a name='afsn3.6'></a>Datoer (klassen Date)</SPAN></H2>

<P LANG="da-DK" CLASS="western">Date-klassen repr&aelig;senterer et
punkt i tiden (en dato og et klokkesl&aelig;t). 
</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog4_html_308c791.gif" NAME="Objekt53" ALIGN=BOTTOM></P>
<P LANG="da-DK" CLASS="western">For at oprette et dato-objekt, der
repr&aelig;senterer dags dato og tid, skriver vi:</P>
<PRE CLASS="kode-western">  Date netopNu;
  netopNu = new Date();                    <I>// dags dato og tidspunkt lige nu</I></PRE><P LANG="da-DK" CLASS="western">
new-operatoren er som bekendt bindeleddet mellem en klasse (f.eks.
Date) og et objekt (en konkret dato, f.eks. 24/12 2000 kl. 18:37). 
</P>
<P LANG="da-DK" CLASS="western">For at oprette en dato, der
repr&aelig;senterer et andet tidspunkt, kan vi bruge en af de andre
konstrukt&oslash;rer, der f&aring;r &aring;rstal, m&aring;ned (regnet
fra 0), dag, time og minut. Undertegnede er f&oslash;dt den 1. januar
1971, s&aring; min f&oslash;dselsdag kunne oprettes med:</P>
<PRE CLASS="kode-western">  jacobsF&oslash;dselsdag = new Date(71,0,1,12,00); <I>// 1.januar 1971 kl. 12:00</I></PRE>
<P LANG="da-DK" CLASS="western">I appendiks 3.9.5 er et udvalg af
Date-klassens konstrukt&oslash;rer og metoder beskrevet.</P>

<P LANG="da-DK" CLASS="western">Eksemplet nedenfor regner p&aring;
min f&oslash;dselsdato og finder ud af, hvorn&aring;r jeg var halvt
s&aring; gammel som nu.</P>
<PRE CLASS="kode-western"><I>// Datoer.java</I>
<I>// Viser brugen af Date-klassen og dens metoder.</I>

import java.util.*; <I>// Date-klassen er i pakken java.util</I>

public class Datoer
{
  public static void main (String[] arg)
  {
    Date netopNu;
    Date jacob;

    netopNu = new Date();                    <I>// dags dato og tidspunkt lige nu</I>
    jacob = new Date(71,0,1,12,00);          <I>// 1. januar 1971 kl. 12:00</I>

    System.out.println(&quot;Dags dato: &quot;+netopNu.toString());
    System.out.println(&quot;Jacob blev f&oslash;dt &quot;+jacob); <I>// .toString() implicit</I>

<I>    // Lad os regne Jacobs alder ud (i millisekunder)</I>
    long nuMs;
    long jacobMs;
    long alderMs;

    nuMs = netopNu.getTime();
    jacobMs = jacob.getTime();
    alderMs = nuMs - jacobMs;
 
<I>    // Hvorn&aring;r var han halvt s&aring; gammel?</I>
    jacob.setTime(nuMs - alderMs/2);
    System.out.println(&quot;Jacob var halvt s&aring; gammel &quot;+jacob);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Dags dato: Tue Sep 25 06:07:46 CEST 2007
Jacob blev f&oslash;dt Fri Jan 01 12:00:00 CET 1971
Jacob var halvt s&aring; gammel Sun May 14 09:33:53 CEST 1989</PRE><P LANG="da-DK" CLASS="western">
Kaldet jacob.setTime(...) &aelig;ndrer objektet, s&aring; Jacobs
f&oslash;dselsdag blev glemt.</P>
<P LANG="da-DK" CLASS="western">Man kan g&oslash;re meget mere med
datoer end vist her: 
</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">GregorianCalendar-klassen
  repr&aelig;senterer vort kalendersystem (det gregorianske /
  julianske) og har alle de kalenderfunktioner, man kunne &oslash;nske
  sig. Med den kan man arbejde med ugedage, m&aring;neder, &aring;r,
  tidszoner, sommertid etc. 
  </P>
  <LI><P LANG="da-DK" CLASS="western">Med DateFormat-klassen kan man
  formatere og udskrive datoer langt p&aelig;nere end med toString()
  og p&aring; alle mulige sprog (bl.a. p&aring; dansk). Klassen kan
  ogs&aring; g&aring; den anden vej: Analysere en tekststreng og finde
  frem til datoen den repr&aelig;senterer.</P>
</UL>

<H3 CLASS="western">3.6.1 <a name='afsn3.6.1'></a>Opgaver</H3>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Ret Datoer-programmet s&aring;dan,
  at Jacobs f&oslash;dselsdato ikke g&aring;r tabt (opret et tredje
  objekt, i stedet for at &aelig;ndre i jacob-objektet).</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der udskriver
  datoen for i morgen, om en uge og om et &aring;r.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der ud fra en
  persons f&oslash;dselsdato udskriver alle f&oslash;dselsdage, som
  personen har fejret indtil nu (lav f.eks. en while-l&oslash;kke,
  hvor du t&aelig;ller &aring;r frem fra f&oslash;dselsdatoen og
  brug metoden before(), til at tjekke, om du er n&aring;et frem til
  nu).</P>
</OL>
<H2 CLASS="western" STYLE="">3.7 <a name='afsn3.7'></a>Test dig
selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.7">
  <input type='checkbox' name='vis' value='3.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">3.8 <a name='afsn3.8'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.8">
  <input type='checkbox' name='vis' value='3.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">3.9 <a name='afsn3.9'></a>Appendiks</SPAN></H2>
<P LANG="da-DK" CLASS="western">Her finder du en oversigt over de
vigtigste klasser og deres vigtigste metoder. P&aring; adressen
<A CLASS="western" HREF="http://java.sun.com/javase/6/docs/api/">http://java.sun.com/javase/6/docs/api/</A>
findes en komplet oversigt.</P>

<H3 CLASS="western">3.9.1 <a name='afsn3.9.1'></a>Klassen Point</H3>
<P LANG="da-DK" CLASS="western">Point repr&aelig;senterer et punkt
med en x- og y-koordinat. 
</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>java.awt.Point - punkter med
en x- og y-koordinat - skal importeres med import java.awt.*;</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="text-decoration: none">
<B>Variabler</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int x  x-koordinaten</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int y  y-koordinaten</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Konstrukt&oslash;rer</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Point()</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
  Opretter et punkt i (0,0).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Point(int x, int y)<BR>Opretter et punkt i (x,y).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Point(Point p)<BR>Opretter et punkt med samme (x,y)-koordinater som
p.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
void <B>move</B>(int x, int y)<BR>S&aelig;tter punktets koordinater.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">void
</SPAN><B>translate</B>(int x, int y)<BR>Rykker punktets koordinater
relativt i forhold til, hvor det er.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">double <B>distance</B>(Point
etAndetPunkt)<BR>Giver afstanden fra punktet til <I>etAndetPunkt</I>.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>equals</B>(Object
obj)<BR>Unders&oslash;ger, om punktet har samme koordinater som <I>obj</I><SPAN STYLE="font-style: normal">.
Returnerer true, hvis det er tilf&aelig;ldet og false, hvis obj ikke
er et punkt eller hvis det har andre koordinater.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">String
</SPAN><SPAN STYLE="font-style: normal"><B>toString</B></SPAN><SPAN STYLE="font-style: normal">()<BR>giver
en strengrepr&aelig;sentation af punktet med (x,y)-koordinater</SPAN>,
f.eks. java.awt.Point[x=0,y=0]</P>

<H3 CLASS="western" STYLE="">3.9.2 <a name='afsn3.9.2'></a>Klassen
Rectangle</H3>
<P LANG="da-DK" CLASS="western">Rectangle repr&aelig;senterer et
todimensionalt rektangel.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>java.awt.Rectangle -
todimensionalt rektangel - skal importeres med import java.awt.*;</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="text-decoration: none">
<B>Variabler</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int x  x-koordinat p&aring; &oslash;verste venstre hj&oslash;rne</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int y  y-koordinat p&aring; &oslash;verste venstre hj&oslash;rne</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int width  bredden</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
int height  h&oslash;jden</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Konstrukt&oslash;rer</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Rectangle()<BR>opretter et rektangel i (0,0), hvis bredde og h&oslash;jde
er 0.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
Rectangle(int bredde, int h&oslash;jde)<BR>opretter et rektangel i
(0,0) med den angivne bredde og h&oslash;jde.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">Rectangle(int
x, int y, int bredde, int h&oslash;jde)<BR>opretter et rektangel i
(x,y) med den angivne bredde og h&oslash;jde</SPAN>.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">Rectangle(Point
p)<BR>opretter et rektangel i </SPAN><I><SPAN STYLE="font-weight: medium">p</SPAN></I><SPAN STYLE="font-weight: medium">,
hvis bredde og h&oslash;jde er 0</SPAN>.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">void
</SPAN><B>add </B><SPAN STYLE="font-weight: medium">(Point p)
<BR>udvider rektanglet s&aring;dan, at det ogs&aring; omfatter
punktet </SPAN><I><SPAN STYLE="font-weight: medium">p</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-weight: medium">
void <B>translate </B>(int x, int y)<BR>rykker rektanglets
koordinater relativt i forhold til, hvor det er.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">boolean
</SPAN><B>contains </B><SPAN STYLE="font-weight: medium">(Point
p)<BR>returnerer true, hvis </SPAN><I><SPAN STYLE="font-weight: medium">p</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">
er inden for rektanglet, ellers false.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">boolean
</SPAN></SPAN><SPAN STYLE="font-style: normal"><B>intersects
</B></SPAN><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">(Rectangle
r)<BR>returnerer true, hvis rektanglet og </SPAN></SPAN><I><SPAN STYLE="font-weight: medium">r</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">
overlapper.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">Rectangle
</SPAN></SPAN><SPAN STYLE="font-style: normal"><B>intersection
</B></SPAN><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">(Rectangle
r)<BR>unders&oslash;ger overlappet (f&aelig;llesm&aelig;ngden,
snitm&aelig;ngden) mellem rektanglet og </SPAN></SPAN><I><SPAN STYLE="font-weight: medium">r</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">
og returnerer et rektangel, der repr&aelig;senterer det f&aelig;lles
overlap.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">Rectangle
</SPAN></SPAN><SPAN STYLE="font-style: normal"><B>union</B></SPAN><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">(Rectangle
r)<BR>returnerer et rektangel, der repr&aelig;senterer
foreningsm&aelig;ngden, dvs. det mindste rektangel, der
indeholder b&aring;de </SPAN></SPAN><I><SPAN STYLE="font-weight: medium">r</SPAN></I><SPAN STYLE="font-style: normal"><SPAN STYLE="font-weight: medium">
og dette rektangel.</SPAN></SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>equals</B>(Object
obj)<BR>Unders&oslash;ger, om rektanglet har samme koordinater og m&aring;l
som <I>obj</I><SPAN STYLE="font-style: normal">. Returnerer true,
hvis det er tilf&aelig;ldet og false, hvis obj ikke er et rektangel,
eller hvis det har andre koordinater eller m&aring;l</SPAN>.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">String
</SPAN><SPAN STYLE="font-style: normal"><B>toString</B></SPAN><SPAN STYLE="font-style: normal">()<BR>giver
en strengrepr&aelig;sentation af rektanglet med (x,y)-koordinater og
m&aring;l.</SPAN></P>

<H3 CLASS="western" STYLE="">3.9.3 <a name='afsn3.9.3'></a>Klassen
String</H3>
<P LANG="da-DK" CLASS="western">Strenge er specielle ved, at de ikke
kan &aelig;ndres, n&aring;r de f&oslash;rst er oprettet.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>java.lang.String -
tekststrenge</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">char <B>charAt</B>
(int indeks)<BR>returnerer tegnet p&aring; det angivne <I>indeks</I>.
Indeks t&aelig;ller fra 0.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>replace</B>
(String s&oslash;getekst, String erstatning)<BR>Giver en ny streng,
som er identisk med denne streng, bortset fra at alle steder i
strengen, hvor teksten <I>s&oslash;getekst</I> st&aring;r, er blevet
erstattet med teksten <I>erstatning</I><SPAN STYLE="font-style: normal">.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>substring</B>
(int startindeks)<BR>Returnerer en ny streng, som er en del af denne
streng. Delstrengen starter ved <I>startindeks</I> og g&aring;r
til slutningen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>substring</B>
(int startindeks, int slutindeks)<BR>Returnerer en ny streng, som er
en del af denne streng. Delstrengen starter ved <I>startindeks</I>
og slutter ved <I>slutindeks</I> (til og med <I>slutindeks</I>-1).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String[] <B>split</B>
(String regul&aelig;rtUdtryk)<BR>Deler strengen op efter
skilletegnene i <I>regul&aelig;rtUdtryk</I> og returnerer et
streng-array med bidderne. Et par eksempler p&aring; brug kan findes
sidst i <a href='kapitel3.jsp#afsn3.10.5'>afsnit 3.10.5</a> og i <a href='kapitel15.jsp#afsn15.3.1'>afsnit 15.3.1</a>.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toLowerCase</B>
()<BR>returnerer en ny streng, som er identisk med denne streng,
bortset fra at alle store bogstaver er erstattet med sm&aring;.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toUpperCase</B>
()<BR>returnerer en ny streng, som er identisk med denne streng,
bortset fra at alle sm&aring; bogstaver er erstattet med store.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>trim</B>
()<BR>returnerer en ny streng, som er identisk med denne streng,
bortset fra at alle blanktegn, tabulatortegn, linjeskift etc. er
fjernet fra begge ender af strengen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>length</B>
()<BR>returnerer l&aelig;ngden af (antal tegn i) strengen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>indexOf</B>
(String str)<BR>returnerer indekset p&aring; den f&oslash;rste
forekomst af <I>str</I> som delstreng. Hvis <I>str</I> ikke er en
delstreng, returneres -1.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">int
</SPAN><SPAN STYLE="font-style: normal"><B>lastIndexOf</B></SPAN><SPAN STYLE="font-style: normal">
(String str)<BR>returnerer indekset p&aring; den sidste forekomst af
</SPAN><I>str</I><SPAN STYLE="font-style: normal"> som delstreng.
Hvis </SPAN><I>str</I><SPAN STYLE="font-style: normal"> ikke er en
delstreng, returneres -1.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>startsWith</B>
(String str)<BR>returnerer sand, hvis denne streng starter med de
samme tegn som <I>str</I><SPAN STYLE="font-style: normal">, ellers
falsk.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>endsWith</B>
(String str)<BR>returnerer sand, hvis denne streng slutter med de
samme tegn som <I>str</I><SPAN STYLE="font-style: normal">, ellers
falsk.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>equals</B>
(String str)<BR>returnerer sand, hvis denne streng har samme indhold
som <I>str</I>, ellers falsk.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western" STYLE="font-style: normal">
boolean <B>equalsIgnoreCase</B> (String str)<BR>returnerer sand, hvis
denne streng har samme indhold som <I>str</I>, ellers falsk. Der
skelnes ikke mellem store og sm&aring; bogstaver.</P>
<P LANG="da-DK" CLASS="western">To strenge <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s2</SPAN></SPAN></FONT></FONT>
sammenlignes, ved at kalde <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1.equals(s2)</SPAN></SPAN></FONT></FONT>,
ikke med <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">s1==s2</SPAN></SPAN></FONT></FONT>
(der sammenligner objektreferencer, j.v.f. <a href='kapitel3.jsp#afsn3.4.5'>afsnit 3.4.5</a>).</P>
<H3 CLASS="western" STYLE="">3.9.4 <a name='afsn3.9.4'></a>Specialtegn
i strenge</H3>
<P LANG="da-DK" CLASS="western">Visse tegn kan man ikke skrive
direkte i tekststrenge i kildeteksten. De er opf&oslash;rt herunder:</P>

<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">&Oslash;nsket tegn</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">I kildeteksten skrives</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Tabulator</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\t</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Linjeskift (eng.: newline)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\n</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Vognretur (eng.: carriage
        return). Bruges sj&aelig;ldent</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\r</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Bak (eng.: backspace). Bruges
        sj&aelig;ldent</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Anf&oslash;relsestegn &quot;</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\&quot;</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Apostrof '</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\'</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">En bagstreg \ (eng.: backslash)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\\</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">Unikode-tegn nummer XXXX</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">\uXXXX</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<P LANG="da-DK" CLASS="western">Unikode-tegn skrives som fire
hexadecimale cifre (0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F). F.eks. kan de
gr&aelig;ske bogstaver findes p&aring; &quot;\u0390&quot; til
&quot;\u03F3&quot; (det gr&aelig;ske pi skrives med &quot;\u03C0&quot;)
og de kyrilliske tegn findes fra &quot;\u0400&quot; til &quot;\u047F&quot;.
Unikode-tegntabellen kan findes p&aring; <A CLASS="western" HREF="http://unicode.org/">http://unicode.org</A>
</P>
<P LANG="da-DK" CLASS="western">Eksempler: 
</P>
<PRE CLASS="ikke-javakode-western">System.out.println(&quot;Jacob\n\n\n\tNordfaaa\b\blk&quot;);</PRE>
<HR>
<PRE CLASS="ikke-javakode-western">Jacob

  Nordfalk</PRE>
<PRE CLASS="ikke-javakode-western">System.out.println(&quot;\t\&quot;At v&aelig;re eller ikke v&aelig;re\n\tdet er sp&oslash;rgsm&aring;let.\&quot;&quot;);
System.out.println(&quot;\t\t\t\t\t\t\t\t\t\tShakespeare&quot;);</PRE>
<HR>
<PRE CLASS="ikke-javakode-western">  &quot;At v&aelig;re eller ikke v&aelig;re
  det er sp&oslash;rgsm&aring;let.&quot;
                    Shakespeare</PRE>
<H3 CLASS="western" STYLE="">3.9.5 <a name='afsn3.9.5'></a>Klassen
Date</H3>
<P LANG="da-DK" CLASS="western">Date repr&aelig;senterer en tid, dvs.
en dato og et klokkesl&aelig;t. Se eksempler p&aring; brug i <a href='kapitel3.jsp#afsn3.6'>afsnit
3.6</a>.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>java.util.Date - et tidspunkt
- skal importeres med import java.util.*;</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Konstrukt&oslash;rer</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">Date ()<BR>opretter et
Date-objekt, som repr&aelig;senterer tidspunktet, da det blev
oprettet.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">Date (long
tid_i_millisekunder)<BR>opretter et Date-objekt, som repr&aelig;senterer
et tidspunkt, der er <I>tid_i_millisekunder</I> efter 1. januar 1970
kl 00:00:00 GMT.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">Date (int &aring;r,
int m&aring;ned, int dag, int timer, int
minutter)<SPAN STYLE="font-style: normal">  </SPAN><I>(frar&aring;des)</I><BR>opretter
et Date-objekt med det givne tidspunkt. Bem&aelig;rk, at <I>&aring;r</I><SPAN STYLE="font-style: normal">
regnes fra &aring;r 1900 (1997 svarer til </SPAN><I>&aring;r</I><SPAN STYLE="font-style: normal">=97)
og</SPAN> <I>m&aring;ned</I><SPAN STYLE="font-style: normal"> regnes
fra 0 (januar svarer til </SPAN><I>m&aring;ned</I><SPAN STYLE="font-style: normal">=0).</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">Date (String
dato)<SPAN STYLE="font-style: normal">  </SPAN><I>(frar&aring;des)</I><BR>opretter
et Date-objekt, som repr&aelig;senterer det tidspunkt, <I>dato</I>
indeholder.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">long <B>getTime</B>
()<BR>returnerer antal millisekunder siden 1. januar 1970 kl.
00:00:00 GMT repr&aelig;senteret af dette Date-objekt.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>setTime</B>
(long tid_i_millisekunder)<BR>&aelig;ndrer dette Date-objekt til at
repr&aelig;sentere et tidspunkt, der er <I>tid_i_millisekunder</I>
efter 1. januar 1970 kl 00:00:00 GMT.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>after</B>
(Date hvorn&aring;r)<BR>unders&oslash;ger, om denne dato er efter
<I>hvorn&aring;r</I>-datoen.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>before</B>
(Date hvorn&aring;r)<BR>unders&oslash;ger, om denne dato er f&oslash;r
<I>hvorn&aring;r</I>-datoen.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toString</B>
()<BR>returnerer en strengrepr&aelig;sentation af formen: ugedag mm
dd tt:mm:ss &aring;&aring;&aring;&aring; (f.eks. Man 5. juli 15:23:18
2000). Denne metode kaldes automatisk, hvis man fors&oslash;ger at
l&aelig;gge en dato sammen med en streng med +-operatoren.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>getDate</B>
()    <I>(frar&aring;des)</I><BR>returnerer dagen i m&aring;neden
repr&aelig;senteret af dette objekt.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>setDate</B>
(int dag)<SPAN STYLE="font-style: normal">.  </SPAN><I>(frar&aring;des)</I><BR>&aelig;ndrer
dagen i m&aring;neden til <I>dag</I><SPAN STYLE="font-style: normal">.
S&aelig;ttes den til en dag uden for denne m&aring;ned, opfattes det
som om m&aring;neden skal &aelig;ndres tilsvarende, f.eks. vil
setDate(32) g&aring; ind i n&aelig;ste m&aring;ned.  </SPAN>
</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">T</SPAN>ilsvarende
findes <B>getYear()</B>, <B>setYear()</B>, <B>getMonth()</B>,
<B>setMonth()</B>, <B>getHours()</B>, <B>setHours(),
getMinutes(), setMinutes()</B>, <B>getSeconds()</B> og
<B>setSeconds()</B>.<SPAN STYLE="font-style: normal">  </SPAN><I>(frar&aring;des)</I></P>

<P LANG="da-DK" CLASS="western">(frar&aring;des): Disse metoder blev
frar&aring;det fra JDK version 1.1, fordi de ikke underst&oslash;tter
andre kalendere end det gregorianske kalendersystem, der bruges
i den vestlige verden. Det betyder dog ikke det store for europ&aelig;iske
programmer.</P>
<H3 CLASS="western" STYLE="">3.9.6 <a name='afsn3.9.6'></a>Klassen
ArrayList</H3>
<P LANG="da-DK" CLASS="western">ArrayList er en liste af andre
objekter. Se <a href='kapitel3.jsp#afsn3.5'>afsnit 3.5</a> for eksempler p&aring; brug af ArrayList.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>java.util.ArrayList - en liste
af objekter - skal importeres med import java.util.*;</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Konstrukt&oslash;rer</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">ArrayList&lt;Elementtype&gt;
()<BR>opretter en tom liste med elementer af klassen <I>Elementtype</I>.
&lt; Elementtype&gt; kan udelades.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><B>Metoder</B></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>add</B>(
Elementtype element )<BR>f&oslash;jer <I>element</I><SPAN STYLE="font-style: normal">
til slutningen af listen. Hvis Elementtype var angivet i
konstrukt&oslash;ren skal </SPAN><I>element</I><SPAN STYLE="font-style: normal">
v&aelig;re af denne type. Elementtyper som Integer eller Double
tillader ogs&aring; </SPAN><I>autoboxing</I><SPAN STYLE="font-style: normal">
af den tilsvarende simple type (int hhv. double), dvs. liste=new
ArrayList&lt;Integer&gt;() tillader liste.add(5).</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>add</B>( int
indeks , element )<BR>inds&aelig;tter <I>element</I><SPAN STYLE="font-style: normal">
i listen lige f&oslash;r plads nummer </SPAN><I>indeks</I>. F&oslash;rste
element er p&aring; plads nummer 0.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">Elementtype <B>remove</B>(
int indeks )<BR>fjerner elementet p&aring; <SPAN STYLE="font-style: normal">plads
nummer </SPAN><I>indeks </I><SPAN STYLE="font-style: normal">og
returnerer elementet, der blev fjernet.</SPAN></P>

<P LANG="da-DK" CLASS="klasseoversigt-western">boolean
<B>isEmpty</B>()<BR>returnerer sand, hvis listen er tom (indeholder 0
elementer).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>size</B>()<BR>returnerer
antallet af elementer i listen.</P>

<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-style: normal">Elementtype</SPAN>
<B>get</B>(int indeks)<BR>returnerer en reference til objektet p&aring;
plads nummer <I>indeks</I><SPAN STYLE="font-style: normal">. Har du
udeladt &lt;Elementtype&gt; i konstrukt&oslash;ren skal du huske at
lave en typekonvertering af resultatet som beskrevet i <a href='kapitel3.jsp#afsn3.5.4'>afsnit 3.5.4</a>.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">boolean <B>contains</B>(
objekt )<BR>returnerer sand, hvis <I>objekt</I><SPAN STYLE="font-style: normal">
findes i listen.</SPAN></P>
<P LANG="da-DK" CLASS="klasseoversigt-western">int <B>indexOf</B>(
objekt )<BR>returnerer indekset p&aring; f&oslash;rste forekomst af
<I>objekt</I><SPAN STYLE="font-style: normal"> i listen. Hvis den
ikke findes, returneres -1.</SPAN></P>

<P LANG="da-DK" CLASS="klasseoversigt-western">String <B>toString</B>
()<BR>returnerer listens indhold som en streng. Dette sker ved at
konvertere hver af elementerne til en streng.</P>

<H4 CLASS="western">Autoboxing</H4>
<P LANG="da-DK" CLASS="western"><SPAN STYLE="font-style: normal">Elementtyper
som Integer eller Double tillader ogs&aring; </SPAN><I>autoboxing</I><SPAN STYLE="font-style: normal">
af den tilsvarende simple type. Det vil f.eks. sige, at man kan have
en liste af den simple type int me</SPAN>d:</P>
<PRE CLASS="kode-western">    ArrayList&lt;Integer&gt; liste = new ArrayList&lt;Integer&gt;();

    liste.add(8);                        <I>// tilf&oslash;j element '8' p&aring; f&oslash;rste plads</I>

    int nummer = liste.get(0);           <I>// afl&aelig;s 8-tallet i listen</I></PRE><P LANG="da-DK" CLASS="western" STYLE="font-style: normal">
Et eksempel findes i <a href='kapitel3.jsp#afsn3.10.2'>afsnit 3.10.2</a>.</P>
<P LANG="da-DK" CLASS="western" STYLE="font-style: normal">Bem&aelig;rk
at selvom det kunne virke logisk, kan man alts&aring; <I>ikke</I><SPAN STYLE="font-style: normal">
skrive f.eks. ArrayList&lt;int&gt; for at oprette en liste af int,
man </SPAN><I>skal</I><SPAN STYLE="font-style: normal"> angive en
objekttype som f.eks. ArrayList&lt;Integer&gt;. </SPAN>
</P>
<H2 CLASS="western" STYLE="">3.10 <a name='afsn3.10'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10">
  <input type='checkbox' name='vis' value='3.10'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.10.1 <a name='afsn3.10.1'></a>S&aelig;tte strenge sammen (klassen
StringBuilder)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10.1">
  <input type='checkbox' name='vis' value='3.10.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.10.2 <a name='afsn3.10.2'></a>Standardmetoder til at arbejde med lister</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10.2">
  <input type='checkbox' name='vis' value='3.10.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
3.10.3 <a name='afsn3.10.3'></a>Lister af simple typer (autoboxing)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10.3">
  <input type='checkbox' name='vis' value='3.10.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.10.4 <a name='afsn3.10.4'></a>Andre slags lister og m&aelig;ngder</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10.4">
  <input type='checkbox' name='vis' value='3.10.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">3.10.5 <a name='afsn3.10.5'></a>N&oslash;gleindekserede
tabeller (klassen HashMap)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel3.jsp#afsn3.10.5">
  <input type='checkbox' name='vis' value='3.10.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.10.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
  er ikke objektet selv. <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
  er kun en reference (pegepind, pointer) til objektet. Endnu har <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">p</SPAN></SPAN></FONT></FONT>
  ikke nogen v&aelig;rdi (man siger, at den er <B>null</B>, dvs.
  referencen peger ingen steder hen).</P>
</DIV>
<DIV ID="sdfootnote2">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>I
  et rigtigt program ville de enkelte kort nok v&aelig;re
  repr&aelig;senteret med objekter fra en Kort-klasse, hvor hvert
  Kort-objekt har objektvariablerne farve og v&aelig;rdi.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel4.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
